import misc.Debug;
import types.DataClass;
import types.Rahmen;


class SimpleProtocol extends Protocol {

    // Variables
    int m_iLastAckSend;

	public SimpleProtocol(Computer a)	{
		super(a);
		sendWindow = new DataClass(8,3);
		m_Buffer1.setMaxSize(sendWindow.maxWindowSize());
		receiveWindow = new DataClass(8,3);
		m_Buffer2.setMaxSize(receiveWindow.maxWindowSize());
		sendWindow.lowerBound(0);
		sendWindow.upperBound(0);
		receiveWindow.lowerBound(0);
		receiveWindow.upperBound(0);
		m_iTimeSteps=4;
        m_iLastAckSend=-1;
	}
	public void Work() {
	    switch (m_Event) {
		case 0: // Event frame send
		    // This Event happens, is Layer n+1 wants to send some data
		    // First check, if sending is allowed
		    if (sendWindow.windowSize()<sendWindow.maxWindowSize()) {
		        // first check, if sequence number belongs to a frame that must be retransmitted
		        Rahmen frame;
		        frame=m_Buffer1.getFrame(sendWindow.upperBound());
		        if (frame==null) {
		            // otherwise
		            // Create new frame with sequencenumber of upperbound
    		        frame = new Rahmen(sendWindow.upperBound(),-1,Rahmen.DATA,m_Computer.getData());
    		        // put it in the buffer
    		        m_Buffer1.addFrame(frame);
		        }
		        // Mark frame as undamaged
		        frame.repair();
		        // Put frame on the way
		        m_Computer.lowerLayerSend(frame);
		        // Start timer (in this case, one timer for each sequence number)
		        // The timer expires after m_iTimeSteps abstract timesteps
		        m_Computer.timer().insertTimer(sendWindow.upperBound(),m_iTimeSteps);
		        sendWindow.incUpperBound(1);
		    }
			break;
		case 1: // Event Accept one Frame
		    // This Event happens, if Layer n+1 is ready to accept and acknowledge
		    // a dataFrame waiting at Layer n
		    // First check, if any Frame is available
		    if (m_InBox.size()>0) {
		        // Take first available frame and remove it from the InBox
		        Rahmen frame = (Rahmen)m_InBox.elementAt(0);
		        m_InBox.removeElement(frame);
		        // Distinguish type of Frame
                if (frame.iKind()==Rahmen.DATA) {
                    // A Data frame arrived
                    // Accept frame and send Acknowledgment
                    m_Computer.writeData(frame.data());
                    m_Computer.lowerLayerSend(new Rahmen(0,receiveWindow.lowerBound(),Rahmen.ACK));
                    m_iLastAckSend = frame.seqNr();
                    receiveWindow.incLowerBound(1);
    	        }

            }
			break;
	    case 2: // Event frame arriving from Lowerlayer
	        // This Event happens, if a Rahmen arrives from Layer n-1
            if (m_Frame.iKind()==Rahmen.DATA) {
                // A Data frame arrived
                // Check the sequence Number
                if (m_Frame.seqNr()==receiveWindow.upperBound()) {
    	            Debug.out("Data accepted");
                    // Accept frame and advance LowerBound
                    receiveWindow.incUpperBound(1);
        	        // put the frame in the InBox
                    m_InBox.addElement(m_Frame);
    	        }
    	        else {
    	            Debug.out("Data out of sequence, Expected: "+Integer.toString(receiveWindow.upperBound()));
                    int iFirst = receiveWindow.subtract(receiveWindow.lowerBound(),receiveWindow.maxWindowSize());
                    int iLast = receiveWindow.lowerBound();
                    if (receiveWindow.isBetween(iFirst,iLast,m_Frame.seqNr())) {
        	            // Out of sequence, purge Frame
        	            // retransmit last Acknowledgement
                        m_Computer.lowerLayerSend(new Rahmen(0,m_Frame.seqNr(),Rahmen.ACK));
                        Debug.out("Resending Ack:"+Integer.toString(m_Frame.seqNr()));
                    }
                }
    	    }
	        if (m_Frame.iKind()==Rahmen.ACK) {
	            // An Acknowledgement arrived, check if it is the right one
	            int iAckExpected = sendWindow.lowerBound();
	            int iLastAckAccepted = sendWindow.upperBound();
	            Debug.out("Ack received expected:"+Integer.toString(iAckExpected)+"Last Accepted:"+Integer.toString(iLastAckAccepted));
                if ((m_Frame.seqNrAck()==iAckExpected)&&(sendWindow.windowSize()>0)) {
//                if (sendWindow.isBetween(iAckExpected,iLastAckAccepted,m_Frame.seqNrAck())) {
                    m_Computer.timer().removeTimer(iAckExpected);
                    m_Buffer1.removeFrame(iAckExpected);
                    sendWindow.incLowerBound(1);
                }
            }
            break;
		case 4: // Event Timeout
		    // Kill all other waiting timers
		    m_Computer.timer().removeAll();
		    // int iFramesLost = sendWindow.subtract(sendWindow.upperBound(),m_iPar1);
		    sendWindow.upperBound(m_iPar1);
		    break;
		}
		if (sendWindow.windowSize()>sendWindow.maxWindowSize()) {
		    Debug.out("Fehler");
		}
	}
	public int anzBuffered() {
	    return(sendWindow.windowSize());
	}
}

